#include "skybox.h"

// ----------------------------------------------------------------------------------------------------------------------------

class COpenGLControl
{
private:
	int Width, Height;
	mat4x4 ModelMatrix, ViewMatrix, ProjectionMatrix, ViewProjectionMatrix;
	
private:
	CSkybox Skybox;
	CTexture Textures[3];
	CShaderProgram Lighting;
	GLuint VBO, VAO;
	int VerticesCount[3];

public:
	CCamera Camera;

public:
	COpenGLControl();
	~COpenGLControl();

	bool Init();
	void Render(float FrameTime);
	void Resize(int Width, int Height);
	void Destroy();
};
